﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja o stanie zatrudnienia</title>
		<script runat="server">

		[DefaultWidth(12)]    
            public enum Półrocze {
                Pierwsze    = 1, 
                Drugie      = 2,
            }    
		    
	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			SetEmpty();			
		}
		
		int rok;
		[Required]
        [Priority(10)]
        [Caption("Raport za rok")]
		public int Rok {
			get { return rok; }
			set {
				if (value==0)
					SetEmpty();
				else
					rok = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        Półrocze półrocze;
		[Required]
        [Priority(20)]
        [Caption("...półrocze")]
        public Półrocze Półrocze {
			get { return półrocze; }
			set {
			    półrocze = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        ZPCHR.WarunkiNaliczania warunkiNaliczaniaDla = ZPCHR.WarunkiNaliczania.PFRON;
        [Priority(30)]
        public ZPCHR.WarunkiNaliczania WarunkiNaliczaniaDla {
            get { return warunkiNaliczaniaDla; }
            set {
                warunkiNaliczaniaDla = value;
                OnChanged(EventArgs.Empty);
            }
        }        
        		
		void SetEmpty() {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			int y = data.Year;
			int m = data.Month;
			if (m>6) {
				rok = y;
                półrocze = Półrocze.Pierwsze;
			}
			else {
				rok = y-1;
                półrocze = Półrocze.Drugie;
			}
		}
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    Dictionary<object, object[]> dict = new Dictionary<object, object[]>();
    List<object> oddzialy = new List<object>();
    string title;

	void OnContextLoad(Object sender, EventArgs args) {
		ReportHeader1["ROK"] = pars.Rok.ToString();
		ReportHeader1["PÓŁROCZE"] = CaptionAttribute.EnumToString(pars.Półrocze);
        ReportHeader1["RAPORT"] = CaptionAttribute.EnumToString(pars.WarunkiNaliczaniaDla);
        title = ReportHeader1.Title;
		
		KadryModule kadry = KadryModule.GetInstance(dc);
        bool jestZpchr = Soneta.Core.CoreModule.GetInstance(dc).Config.Firma.StatusZPChr.Posiada;
				
		int d = ((int)pars.Półrocze-1) * 6;
		for (int i=0; i<6; i++) {		
			YearMonth ym = new YearMonth(pars.Rok, i + d + 1);
			ZPCHR zpchr = new ZPCHR(jestZpchr, ym, pars.WarunkiNaliczaniaDla);
            Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(ym.ToFromTo(), (Wydzial)null, false, true);

            List<Pracownik> list;
            Dictionary<object, List<Pracownik>> dict2 = new Dictionary<object, List<Pracownik>>();
            if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
                Date data = ym.FirstDay;
                foreach (Pracownik pracownik in view) {
                    PracHistoria ph = pracownik[data];
                    OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                    while (of != null) {
			            if (of.GetObjectRight() != AccessRights.Denied &&
                            of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                            break;
                        of = of.Nadrzedny;
                    }
                    if (of == null)
                        continue;
                    if (!dict2.TryGetValue(of, out list))
                        dict2.Add(of, list = new List<Pracownik>());
                    list.Add(pracownik);
                }
            }
            else {
                dict2.Add(string.Empty, list = new List<Pracownik>());
                foreach (Pracownik pracownik in view)
                    list.Add(pracownik);
            }

		    object[] src;
            foreach (object of in dict2.Keys) {
                if (!dict.TryGetValue(of, out src))
                    dict.Add(of, src = new object[6]);
			    src[i] = zpchr.Razem(dict2[of]);
            }
		}

        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
	}
	
	void OnBeforeRow(Object sender, EventArgs args) {
        object of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "");

		Grid1.DataSource = dict[of];
    }

	void Grid1_BeforeRow(object sender, RowEventArgs arg) {
		ZPCHR.MiesiącInfo info = (ZPCHR.MiesiącInfo)arg.Row;
		decimal k5 = info.Etaty;
		decimal k6 = info.EtatyNiepełnosprawni;
		decimal k7 = info.EtatyUmiarkowanyZnaczny;
		if (k5!=0m) {
			col65.EditValue = new Percent(k6/k5);
			col75.EditValue = new Percent(k7/k5);
		}
	}
	
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaOStanieZatrudnienia" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
			    <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA O STANIE ZATRUDNIENIA&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Raport za &lt;strong&gt;%PÓŁROCZE%&lt;/strong&gt; półrocze roku &lt;strong&gt;%ROK%&lt;BR&gt;&lt;/strong&gt;Statystyka: &lt;strong&gt;%RAPORT%&lt;/SPAN&gt;|%ODDZIAL%"
				    runat="server"></cc1:reportheader>
			    <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				    <Columns>
					    <ea:GridColumn RightBorder="Double" Align="Center" DataMember="Miesiąc.Month" Caption="|Miesiąc||(1)"
						    Format="{0:00}" NoWrap="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Pracownicy" Caption="Zatrudnienie w osobach~Pracownicy og&#243;łem|(2)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Niepełnosprawni" Caption="Zatrudnienie w osobach~Niepełnosprawni og&#243;łem|(3)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="UmiarkowanyZnaczny" Caption="Zatrudnienie w osobach~Znaczny i umiarkowany|(4)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Etaty" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Pracownicy og&#243;łem|(5)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyNiepełnosprawni" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Niepełnosprawni og&#243;łem|(6)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="EtatyUmiarkowanyZnaczny" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Umiarkowany i znaczny|(7)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Caption="Wsp&#243;łczynnik (6)/(5)||(8)" HideZero="True" ID="col65"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Caption="Wsp&#243;łczynnik|(7)/(5)||(9)" HideZero="True" ID="col75"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
